clear all;
close all;

%% Load data and shift so that bandstructure can be plotted as lines

load('strip_freq_g0.mat');
bandgap = 330.4e6;
[energy, g0] = lines_shift(Eval_mech.bands, Eval_mech.g0, bandgap);

%% Plot g0 of strip topo mode

figure(1)
hold on;
box on;
set(gca,'FontSize',18)
pbaspect([4.617 1 1])

ylim([0 15])

% xlabel('kx');
xlabel('Frequency');
ylabel('g_0^{(strip)}/2\pi (in kHz)');

shift_freq = -3.523725502690544e6;

% plot(Eval_mech.kx, g0(20,:)/1e3, '-o', 'LineWidth', 2, 'Color', 'blue')
plot(real(energy(20,:)) + shift_freq, g0(20,:)/1e3, ...
    'Color', 'blue', 'LineWidth', 2, 'Marker', '.', ...
    'MarkerFaceColor', 'blue', 'MarkerSize', 15);

%% Plot strip band structure

figure(2)
subplot2 = subplot(1,1,1);
set(subplot2,'FontSize',16,'XTick',[-pi/geom.mech.amech -2*pi/(3*geom.mech.amech) 0 2*pi/(3*geom.mech.amech) pi/geom.mech.amech],...
    'XTickLabel',{'-\pi', '-2\pi/3', '0', '2\pi/3', '\pi'});

xlim(subplot2,[-pi/geom.mech.amech pi/geom.mech.amech]); % Band structure showing the 1st cone
ylim(subplot2,[309.2e6 351.9e6]); % Band structure showing the 1st cone

yticks(linspace(310e6, 350e6, 5))

hold on;
box on;

% for i=1:size(Eval_mech.bands,1)
%     for j=1:size(Eval_mech.bands,2)
%         plot(Eval_mech.kx(j), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
%         plot(-Eval_mech.kx(j), real(Eval_mech.bands(i,j)), 'Color', 'blue', 'LineStyle', 'none','Marker', '.', 'MarkerFaceColor', 'blue', 'MarkerSize', 10);
%     end
% end

for i=1:size(energy,1)
    plot(Eval_mech.kx, real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
    plot(-Eval_mech.kx, real(energy(i,:)), 'Color', 'blue', 'LineWidth', 3);
end

plot(Eval_mech.kx, real(energy(20,:)), 'Color', 'red', 'LineWidth', 3);
% plot(-Eval_mech.kx, real(energy(20,:)), 'Color', 'red', 'LineWidth', 3);

% % Physical edge state modes
% colour_edge_mode = [146/256, 146/256, 146/256, 1];
% 
% plot(Eval_mech.kx, real(energy(19,:)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-Eval_mech.kx, real(energy(19,:)), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% plot(Eval_mech.kx(25:30), real(energy(21,25:30)), 'Color', colour_edge_mode, 'LineWidth', 3);
% plot(-Eval_mech.kx(25:30), real(energy(21,(25:30))), 'Color', colour_edge_mode, 'LineWidth', 3);
% 
% % plot(Eval_mech.kx, real(energy(21,:)), 'Color', colour_edge_mode, 'LineWidth', 2);
% % plot(-Eval_mech.kx, real(energy(21,:)), 'Color', colour_edge_mode, 'LineWidth', 2);